// ==UserScript==
// @name         5ch 同一 ﾜｯﾁｮｲ レス数表示
// @namespace    http://tampermonkey.net/
// @version      1.3
// @description  ワッチョイを集計して[1/N]表示とポップアップリンク化を行う
// @match        *://*.5ch.net/test/read.cgi/*
// @grant        none
// @run-at       document-end
// ==/UserScript==

(function () {
    'use strict';

    const regex = /\(([^()\s]+)\s+([A-Za-z0-9!-/:-@¥[-`{-~]{4,})\)/g;

    function process(container) {
        if (!container) return;

        const posts = container.querySelectorAll('.post');
        const tripMap = new Map();

        posts.forEach(post => {
            const usernames = Array.from(post.querySelectorAll('.postusername')).filter(elem => !elem.closest('.post-content'));

            usernames.forEach(span => {
                // すでに変換済みならスキップ
                if (span.querySelector('.popup-trip')) return;

                const match = span.textContent.match(regex);
                if (!match) return;

                const newContent = [];
                let lastIndex = 0;

                for (const m of span.textContent.matchAll(regex)) {
                    const start = m.index;
                    const end = start + m[0].length;
                    const label = m[1];
                    const trip = m[2];

                    newContent.push(document.createTextNode(span.textContent.slice(lastIndex, start)));
                    newContent.push(document.createTextNode(`(${label} `));

                    const spanTrip = document.createElement('span');
                    spanTrip.className = 'popup-trip';
                    spanTrip.dataset.trip = trip;
                    spanTrip.style.cursor = 'pointer';
                    spanTrip.style.color = '#06c';
                    spanTrip.textContent = trip;
                    newContent.push(spanTrip);

                    newContent.push(document.createTextNode(')'));

                    lastIndex = end;
                }

                newContent.push(document.createTextNode(span.textContent.slice(lastIndex)));

                span.textContent = ''; // 空にしてから
                newContent.forEach(el => span.appendChild(el));
            });
        });

        const popupTrips = Array.from(container.querySelectorAll('.popup-trip')).filter(elem => !elem.closest('.post-content'));
        popupTrips.forEach(elem => {
            const trip = elem.dataset.trip;
            if (!trip) return;
            if (!tripMap.has(trip)) tripMap.set(trip, []);
            tripMap.get(trip).push(elem);
        });

        tripMap.forEach((elements) => {
            const total = elements.length;
            elements.forEach((el, i) => {
                if (el.nextSibling && el.nextSibling.classList?.contains('trip-count-label')) return;

                const label = document.createElement('span');
                label.className = 'trip-count-label';
                label.style.color = '#888';
                label.style.marginLeft = '4px';
                label.textContent = `[ ${i + 1}/${total} ]`;

                el.parentNode.insertBefore(label, el.nextSibling);
            });
        });
    }

    const container = document.getElementById('threadcontent');
    if (container) {
        // 初回
        process(container);

        // 監視設定（ただし、一時停止を許容）
        const observer = new MutationObserver((mutations, obs) => {
            obs.disconnect(); // 一時停止
            try {
                process(container);
            } finally {
                obs.observe(container, { childList: true, subtree: true });
            }
        });

        observer.observe(container, { childList: true, subtree: true });
    }
})();
